<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateReviewsTableFixSchema extends Migration
{
    public function up()
    {
        Schema::table('reviews', function (Blueprint $table) {
            // Add profile_id first
            $table->bigInteger('profile_id')->unsigned()->nullable()->after('User_id');
            $table->foreign('profile_id')->references('Profile_id')->on('candidate_profiles')->onDelete('set null');

            // Reintroduce or modify Rating with CHECK constraint if missing
            if (!Schema::hasColumn('reviews', 'Rating')) {
                $table->integer('Rating')->after('profile_id')->check('Rating BETWEEN 1 AND 5');
            } else {
                $table->integer('Rating')->after('profile_id')->change()->check('Rating BETWEEN 1 AND 5');
            }

            // Add verified_reviewer
            $table->tinyInteger('verified_reviewer')->default(0)->after('Rating');
        });
    }

    public function down()
    {
        Schema::table('reviews', function (Blueprint $table) {
            $table->dropForeign(['profile_id']);
            $table->dropColumn(['profile_id', 'verified_reviewer']);
            // Revert Rating if modified
            $table->dropColumn('Rating');
            $table->integer('Rating')->after('Job_id'); // Revert to original position if needed
        });
    }
}
